---
noteId: "m172dvvdnss5beymg4rxqfeb0x7yhhtn"
title: "Workspace 設計"
tags: []
updatedAt: 1767420830718
docName: "notes:m172dvvdnss5beymg4rxqfeb0x7yhhtn/content"
---

ドキュメントの更新や、メモリの更新、その他のサンドボックスの操作を行う workspace の設計をちゃんと考える

理想的には全てのドキュメントやメモ、ノートなどを配置したレポジトリがあれば、全ての編集作業をエージェントに任せられる、という発想。

しかし、現実的には全てをロードしたワークスペースを用意すると、ロードが重たくなったり、編集をトラッキングするのが複雑になったり、どの情報にフォーカスすべきかがわからなくなったりする。そのために、今のタスクに最適化されたワークスペースを構築する。


## Workspace 設計

- docs はフラットにすべきか、構造を保つべきか

```
- working-docs/ (現在編集対象のドキュメントが配置される)
  - <work-doc1-dir>
  - <work-doc2-dir>
- docs/ (関連の高いドキュメントが配置される
  - <doc3-dir>
  - Folder 1
    - <doc4-dir>
  - Folder 2
    - Folder 3
      - <doc5-dir>
- notes/ (関連の高いノートが配置される）
- chats/ (関連の高いチャットが配置される）
- memories/ (メモリ系の)
  - personal-memory = <personal-memory-doc-dir>
  - team-memories/
    - <team1-memory-doc-dir>
    - <team2-memory-doc-dir>
  - project-memories/
    - <project1-memory-doc-dir>
    - <project2-memory-doc-dir>
- projects/
  - <project1-doc-dir>
  - <project1-doc-dir>
- AGENTS.md 今の更新対象に合わせた
- .codex/
  - skills/
  - AGENTS.md
```


### Doc dir 設計

```
<doc-title-escaped>/
  - document.json
  - project.json (プロジェクトの場合のみ)
  - .state.json (編集時のみ)
  - <page1-title>.md
  - <page2-title>.md
  - <page2-title>/
    - <page3-title>.md
```


### Doc mardown フォーマット

```
---
pageId: ""
title: "Title"
---
# This is a heading

This is a paragraph
```

